<?php
require 'config.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

// Get current user data
$stmt = $pdo->prepare("SELECT id, username, balance, lifetime_earned FROM users WHERE id = ?");
$stmt->execute([$_SESSION['user_id']]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

// Get Top 5 referrers this month (real data)
$leaderboard_stmt = $pdo->prepare("
    SELECT username, monthly_referral_count AS referrals
    FROM users
    WHERE monthly_referral_count > 0
    ORDER BY monthly_referral_count DESC
    LIMIT 5
");
$leaderboard_stmt->execute();
$top_referrers = $leaderboard_stmt->fetchAll(PDO::FETCH_ASSOC);

// Define prize tiers (1st to 5th)
$prizes = [100.00, 75.00, 50.00, 30.00, 20.00];
?>
<!DOCTYPE html>
<html lang="en" class="scroll-smooth">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Shop - Rewards App</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-teal-500 min-h-screen pb-24 text-gray-800">

    <!-- Header -->
    <header class="bg-teal-600 text-white p-4 flex items-center justify-between sticky top-0 z-20 shadow-md">
        <a href="dashboard.php" class="text-3xl font-bold">←</a>
        <h1 class="text-xl font-bold">Shop & Rewards</h1>
        <div class="w-8"></div>
    </header>

    <main class="p-4 space-y-6 max-w-md mx-auto">

        <!-- Your Balance -->
        <div class="bg-white rounded-2xl p-6 shadow-xl text-center">
            <p class="text-gray-600 text-lg">Your Current Balance</p>
            <p class="text-5xl font-bold text-teal-700 mt-2">
                $<?= number_format($user['balance'], 2) ?>
            </p>
            <p class="text-sm text-gray-500 mt-1">
                Lifetime earned: $<?= number_format($user['lifetime_earned'], 2) ?>
            </p>
        </div>

        <!-- Monthly Free Gift Cards -->
        <div class="bg-gradient-to-br from-purple-600 to-indigo-600 text-white rounded-2xl p-6 shadow-xl">
            <h2 class="text-2xl font-bold mb-4 text-center">Monthly Free Gift Cards</h2>
            <p class="text-center mb-5 opacity-90">
                Loyal & active users receive free gift cards monthly
            </p>

            <div class="grid grid-cols-2 gap-4">
                <div class="bg-white/20 backdrop-blur-md rounded-xl p-4 text-center border border-white/30">
                    <div class="text-4xl mb-2">🛒</div>
                    <p class="font-bold text-lg">Amazon</p>
                    <p class="text-sm opacity-90">$10 – $100</p>
                </div>
                <div class="bg-white/20 backdrop-blur-md rounded-xl p-4 text-center border border-white/30">
                    <div class="text-4xl mb-2">▶️</div>
                    <p class="font-bold text-lg">Google Play</p>
                    <p class="text-sm opacity-90">$5 – $50</p>
                </div>
                <div class="bg-white/20 backdrop-blur-md rounded-xl p-4 text-center border border-white/30">
                    <div class="text-4xl mb-2">💳</div>
                    <p class="font-bold text-lg">PayPal</p>
                    <p class="text-sm opacity-90">Up to $75</p>
                </div>
                <div class="bg-white/20 backdrop-blur-md rounded-xl p-4 text-center border border-white/30">
                    <div class="text-4xl mb-2">🎁</div>
                    <p class="font-bold text-lg">More</p>
                    <p class="text-sm opacity-90">Netflix, Spotify...</p>
                </div>
            </div>

            <button class="mt-6 w-full bg-white text-indigo-700 py-4 rounded-xl font-bold text-lg hover:bg-gray-100 transition active:scale-95">
                Check Eligibility & Claim
            </button>
        </div>

        <!-- Real Top Referrers Leaderboard -->
        <div class="bg-white rounded-2xl p-6 shadow-xl">
            <h2 class="text-2xl font-bold text-center mb-5 text-teal-700">Top Referrers This Month</h2>
            <p class="text-center text-gray-600 mb-6">
                1st–5th place win cash prizes added directly to balance
            </p>

            <?php if (empty($top_referrers)): ?>
                <p class="text-center text-gray-500 py-8">
                    No referrals yet this month.<br>Be the first in the leaderboard!
                </p>
            <?php else: ?>
                <div class="space-y-3">
                    <?php foreach ($top_referrers as $rank => $entry): ?>
                        <div class="flex items-center justify-between bg-gray-50 rounded-xl p-4 <?= ($rank === 0) ? 'border-2 border-yellow-400 bg-yellow-50' : '' ?>">
                            <div class="flex items-center gap-4">
                                <span class="text-2xl font-bold w-10 text-center <?= ($rank === 0) ? 'text-yellow-600' : 'text-gray-600' ?>">
                                    <?= $rank + 1 ?>
                                </span>
                                <div>
                                    <p class="font-semibold"><?= htmlspecialchars($entry['username']) ?></p>
                                    <p class="text-sm text-gray-600"><?= $entry['referrals'] ?> referrals</p>
                                </div>
                            </div>
                            <div class="text-right">
                                <p class="font-bold text-green-600 text-xl">
                                    $<?= number_format($prizes[$rank], 2) ?>
                                </p>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>

            <p class="text-center text-sm text-gray-500 mt-6 italic">
                Prizes are automatically added to balance at the end of each month
            </p>
        </div>

    </main>

    <!-- Bottom Nav -->
    <nav class="fixed bottom-0 left-0 right-0 bg-white border-t border-gray-200 flex justify-around py-3 shadow-2xl z-20">
        <a href="dashboard.php" class="flex flex-col items-center text-gray-600 hover:text-teal-600">
            <span class="text-2xl">🏠</span>
            <span class="text-xs">Home</span>
        </a>
        <a href="shop.php" class="flex flex-col items-center text-teal-600">
            <span class="text-2xl">🛒</span>
            <span class="text-xs font-medium">Shop</span>
        </a>
        <a href="answer.php" class="flex flex-col items-center text-gray-600 hover:text-teal-600">
            <span class="text-2xl">❓</span>
            <span class="text-xs">Answer</span>
        </a>
        <a href="logout.php" class="flex flex-col items-center text-gray-600 hover:text-red-600">
            <span class="text-2xl">⋯</span>
            <span class="text-xs">More</span>
        </a>
    </nav>

</body>
</html>