<?php
require 'config.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// ────────────────────────────────────────────────
//  Fetch current user data
// ────────────────────────────────────────────────
$stmt = $pdo->prepare("
    SELECT username, referral_code, balance, lifetime_earned, referral_count
    FROM users 
    WHERE id = ?
");
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

// Build referral link (change domain to your real domain)
$base_url = "https://yourdomain.com/register.php";          // ← CHANGE THIS
$referral_link = $base_url . "?ref=" . urlencode($user['referral_code']);

// ────────────────────────────────────────────────
//  Top 5 referrers this month (real data)
// ────────────────────────────────────────────────
$top_stmt = $pdo->prepare("
    SELECT username, referral_count, monthly_referral_count
    FROM users
    WHERE monthly_referral_count > 0
    ORDER BY monthly_referral_count DESC
    LIMIT 5
");
$top_stmt->execute();
$top_referrers = $top_stmt->fetchAll(PDO::FETCH_ASSOC);

// Prize tiers for top 5 (you can adjust)
$prizes = [100.00, 75.00, 50.00, 30.00, 20.00];
?>

<!DOCTYPE html>
<html lang="en" class="scroll-smooth">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Refer Friends - Rewards App</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-teal-500 min-h-screen pb-24 text-gray-800">

    <!-- Header -->
    <header class="bg-teal-600 text-white p-4 flex items-center justify-between sticky top-0 z-20 shadow-md">
        <a href="dashboard.php" class="text-3xl font-bold">←</a>
        <h1 class="text-xl font-bold">Refer & Earn</h1>
        <div class="w-8"></div>
    </header>

    <main class="p-4 max-w-md mx-auto space-y-6">

        <!-- Your Referral Info -->
        <div class="bg-white rounded-2xl shadow-xl p-6">
            <h2 class="text-2xl font-bold text-teal-700 mb-5 text-center">
                Invite Friends & Earn
            </h2>

            <div class="text-center mb-6">
                <p class="text-lg text-gray-700 mb-2">
                    You earn <strong>$0.50</strong> for every valid referral<br>
                    (real users only — no fake / duplicate accounts)
                </p>
                <p class="text-sm text-gray-500">
                    Valid = new user registers + completes at least one task
                </p>
            </div>

            <div class="space-y-5">
                <!-- Referral Code -->
                <div>
                    <label class="block text-gray-600 font-medium mb-2 text-center">
                        Your Referral Code
                    </label>
                    <div class="flex items-center justify-center bg-gray-100 rounded-xl p-4">
                        <span class="font-mono text-3xl font-bold tracking-wider">
                            <?= htmlspecialchars($user['referral_code']) ?>
                        </span>
                        <button onclick="navigator.clipboard.writeText('<?= htmlspecialchars($user['referral_code']) ?>'); alert('Code copied!')"
                                class="ml-4 text-teal-600 hover:text-teal-800 text-2xl">
                            📋
                        </button>
                    </div>
                </div>

                <!-- Referral Link -->
                <div>
                    <label class="block text-gray-600 font-medium mb-2 text-center">
                        Your Referral Link
                    </label>
                    <div class="bg-gray-100 rounded-xl p-4 break-all text-sm">
                        <span><?= htmlspecialchars($referral_link) ?></span>
                        <button onclick="navigator.clipboard.writeText('<?= htmlspecialchars($referral_link) ?>'); alert('Link copied!')"
                                class="ml-3 text-teal-600 hover:text-teal-800 text-xl">
                            📋
                        </button>
                    </div>
                </div>

                <!-- Your Stats -->
                <div class="grid grid-cols-2 gap-4 text-center bg-teal-50 rounded-xl p-4">
                    <div>
                        <p class="text-sm text-gray-600">Total Referrals</p>
                        <p class="text-3xl font-bold text-teal-700"><?= number_format($user['referral_count'] ?? 0) ?></p>
                    </div>
                    <div>
                        <p class="text-sm text-gray-600">Earned from Referrals</p>
                        <p class="text-3xl font-bold text-green-600">
                            $<?= number_format(($user['referral_count'] ?? 0) * 0.50, 2) ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Top Referrers This Month -->
        <div class="bg-white rounded-2xl shadow-xl p-6">
            <h2 class="text-2xl font-bold text-teal-700 mb-5 text-center">
                Top Referrers – This Month
            </h2>

            <?php if (empty($top_referrers)): ?>
                <p class="text-center text-gray-600 py-10">
                    No referrals tracked this month yet.<br>
                    Be the first on the leaderboard!
                </p>
            <?php else: ?>
                <div class="space-y-4">
                    <?php foreach ($top_referrers as $rank => $entry): ?>
                        <div class="flex items-center justify-between bg-gray-50 rounded-xl p-4 <?= $rank === 0 ? 'border-2 border-yellow-400 bg-yellow-50' : '' ?>">
                            <div class="flex items-center gap-4">
                                <span class="text-3xl font-bold w-12 text-center <?= $rank === 0 ? 'text-yellow-600' : 'text-gray-600' ?>">
                                    <?= $rank + 1 ?>
                                </span>
                                <div>
                                    <p class="font-semibold text-lg"><?= htmlspecialchars($entry['username']) ?></p>
                                    <p class="text-sm text-gray-600">
                                        <?= number_format($entry['monthly_referral_count']) ?> referrals
                                    </p>
                                </div>
                            </div>
                            <div class="text-right">
                                <p class="font-bold text-green-600 text-xl">
                                    $<?= number_format($prizes[$rank], 2) ?>
                                </p>
                                <p class="text-xs text-gray-500">Prize</p>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>

                <p class="text-center text-sm text-gray-500 mt-6 italic">
                    Top 5 earners receive cash prizes added to balance at month end
                </p>
            <?php endif; ?>
        </div>

    </main>

    <!-- Bottom Navigation -->
    <nav class="fixed bottom-0 left-0 right-0 bg-white border-t border-gray-200 flex justify-around py-3 shadow-2xl z-20">
        <a href="dashboard.php" class="flex flex-col items-center text-gray-600 hover:text-teal-600">
            <span class="text-2xl">🏠</span>
            <span class="text-xs">Home</span>
        </a>
        <a href="shop.php" class="flex flex-col items-center text-gray-600 hover:text-teal-600">
            <span class="text-2xl">🛒</span>
            <span class="text-xs">Shop</span>
        </a>
        <a href="answer.php" class="flex flex-col items-center text-gray-600 hover:text-teal-600">
            <span class="text-2xl">❓</span>
            <span class="text-xs">Answer</span>
        </a>
        <a href="more.php" class="flex flex-col items-center text-teal-600">
            <span class="text-2xl">⋯</span>
            <span class="text-xs font-medium">More</span>
        </a>
    </nav>

</body>
</html>