<?php
// TEMP DEBUG - REMOVE LATER
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require 'config.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// Message & class preparation
$message = '';
$message_class = 'p-4 rounded-xl bg-gray-100 text-gray-800 border-l-4 border-gray-500';

// Handle form submit
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['game_id']) && isset($_POST['submitted_code'])) {
    $game_id = (int)$_POST['game_id'];
    $code = trim($_POST['submitted_code']);

    try {
        $stmt = $pdo->prepare("SELECT id, game_code, reward_amount, is_active FROM games WHERE id = ? AND is_active = 1");
        $stmt->execute([$game_id]);
        $game = $stmt->fetch();

        if (!$game) {
            $message = "Game not found or unavailable.";
            $message_class = 'p-4 rounded-xl bg-red-100 text-red-800 border-l-4 border-red-500';
        } else {
            $check = $pdo->prepare("SELECT 1 FROM user_game_claims WHERE user_id = ? AND game_id = ?");
            $check->execute([$user_id, $game_id]);

            if ($check->fetch()) {
                $message = "Reward already claimed for this game.";
                $message_class = 'p-4 rounded-xl bg-yellow-100 text-yellow-800 border-l-4 border-yellow-500';
            } else {
                $correct = (strtolower($code) === strtolower($game['game_code']));

                if ($correct && $game['reward_amount'] > 0) {
                    $pdo->prepare("INSERT INTO user_game_claims (user_id, game_id, submitted_code) VALUES (?, ?, ?)")
                        ->execute([$user_id, $game_id, $code]);

                    $pdo->prepare("UPDATE users SET balance = balance + ?, lifetime_earned = lifetime_earned + ? WHERE id = ?")
                        ->execute([$game['reward_amount'], $game['reward_amount'], $user_id]);

                    $message = "Success! You earned $" . number_format($game['reward_amount'], 2);
                    $message_class = 'p-4 rounded-xl bg-green-100 text-green-800 border-l-4 border-green-500';
                } else {
                    $message = "Wrong code. Try again.";
                    $message_class = 'p-4 rounded-xl bg-red-100 text-red-800 border-l-4 border-red-500';
                }
            }
        }
    } catch (Exception $e) {
        $message = "Error: " . htmlspecialchars($e->getMessage());
        $message_class = 'p-4 rounded-xl bg-red-100 text-red-800 border-l-4 border-red-500';
    }
}

// Load games
$games = [];
try {
    $stmt = $pdo->prepare("
        SELECT g.id, g.title, g.description, g.play_store_link, g.reward_amount,
               CASE WHEN EXISTS (SELECT 1 FROM user_game_claims WHERE user_id = ? AND game_id = g.id) THEN 1 ELSE 0 END AS already_claimed
        FROM games g WHERE g.is_active = 1
        ORDER BY g.reward_amount DESC, g.id
    ");
    $stmt->execute([$user_id]);
    $games = $stmt->fetchAll();
} catch (Exception $e) {
    $message = "Failed to load games: " . htmlspecialchars($e->getMessage());
    $message_class = 'p-4 rounded-xl bg-red-100 text-red-800 border-l-4 border-red-500';
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Games - Rewards App</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-teal-500 min-h-screen pb-20">

    <header class="bg-teal-600 text-white p-4 flex justify-between items-center sticky top-0 z-10">
        <a href="dashboard.php" class="text-2xl">← Back</a>
        <h1 class="text-xl font-bold">Games & Earn</h1>
        <div></div>
    </header>

    <main class="p-4 max-w-md mx-auto">

        <?php if ($message): ?>
            <div class="<?= $message_class ?>">
                <?= $message ?>
            </div>
        <?php endif; ?>

        <div class="bg-white rounded-xl shadow p-5">
            <h2 class="text-xl font-bold text-center mb-4">Available Games</h2>

            <?php if (empty($games)): ?>
                <p class="text-center py-8 text-gray-600">No games available yet.</p>
            <?php else: ?>
                <?php foreach ($games as $g): ?>
                    <div class="border rounded-lg mb-4 p-4 bg-gray-50">
                        <h3 class="font-bold"><?= htmlspecialchars($g['title']) ?></h3>
                        <?php if ($g['description']): ?>
                            <p class="text-sm text-gray-600 mt-1"><?= nl2br(htmlspecialchars($g['description'])) ?></p>
                        <?php endif; ?>
                        <p class="text-green-600 font-semibold mt-2">
                            Reward: $<?= number_format($g['reward_amount'], 2) ?>
                            <?php if ($g['already_claimed']): ?>
                                <span class="text-xs text-gray-500">(claimed)</span>
                            <?php endif; ?>
                        </p>

                        <a href="<?= htmlspecialchars($g['play_store_link']) ?>" target="_blank"
                           class="block mt-3 bg-blue-600 text-white text-center py-2 rounded hover:bg-blue-700">
                            Download on Play Store
                        </a>

                        <?php if (!$g['already_claimed']): ?>
                            <form method="post" class="mt-4">
                                <input type="hidden" name="game_id" value="<?= $g['id'] ?>">
                                <input type="text" name="submitted_code" placeholder="Enter game code" required
                                       class="w-full p-2 border rounded mb-2">
                                <button type="submit" class="w-full bg-teal-600 text-white py-2 rounded hover:bg-teal-700">
                                    Submit Code & Claim
                                </button>
                            </form>
                        <?php else: ?>
                            <p class="text-center text-green-600 mt-3 font-medium">Reward claimed ✓</p>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </main>

</body>
</html>