<?php
require 'config.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$_SESSION['user_id']]);
$user = $stmt->fetch() ?: [
    'balance'         => 0.00,
    'lifetime_earned' => 10.00,
    'level'           => 'L1: Pearl',
    'streak_days'     => 0,
    'username'        => $_SESSION['username'] ?? 'Guest',
    'referral_code'   => 'XXXXXX'   // fallback – should come from DB
];

// Demo / placeholder values – replace with real logic later
$daily_goal_progress    = 0;
$daily_goal_target      = 30;
$monthly_bonus          = 14;
$first_bonus_remaining  = 3;
$streak_bonus           = 2;
$to_next_level          = 0.50;
$swago_earn             = 500;
?>
<!DOCTYPE html>
<html lang="en" class="scroll-smooth">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Rewards App</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-teal-500 min-h-screen pb-24 text-gray-800">

    <!-- Sidebar Overlay (click to close) -->
    <div id="sidebarOverlay" class="fixed inset-0 bg-black/50 z-30 hidden transition-opacity duration-300"></div>

    <!-- Slide-in Sidebar -->
    <div id="sidebar" class="fixed top-0 left-0 h-full w-72 bg-white shadow-2xl z-40 -translate-x-full transition-transform duration-300 ease-in-out">
        <div class="p-5 border-b border-gray-200 flex items-center justify-between">
            <h2 class="text-xl font-bold text-teal-700">Menu</h2>
            <button id="closeSidebar" class="text-gray-600 hover:text-red-600 text-2xl">×</button>
        </div>
        <div class="p-4 space-y-2">
            <a href="refer.php" class="flex items-center gap-4 p-4 rounded-xl hover:bg-teal-50 active:bg-teal-100 transition">
                <svg class="w-6 h-6 text-teal-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/>
                </svg>
                <span class="text-lg font-medium">Refer Friends</span>
            </a>
            <a href="cashout.php" class="flex items-center gap-4 p-4 rounded-xl hover:bg-teal-50 active:bg-teal-100 transition">
                <svg class="w-6 h-6 text-teal-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a5 5 0 00-10 0v2m-2 4h14a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2z"/>
                </svg>
                <span class="text-lg font-medium">Cash Out</span>
            </a>
            <a href="game.php" class="flex items-center gap-4 p-4 rounded-xl hover:bg-teal-50 active:bg-teal-100 transition">
                <svg class="w-6 h-6 text-teal-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14.828 14.828a4 4 0 01-5.656 0M9 10h.01M15 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                <span class="text-lg font-medium">Games</span>
            </a>
            <a href="profile.php" class="flex items-center gap-4 p-4 rounded-xl hover:bg-teal-50 active:bg-teal-100 transition">
                <svg class="w-6 h-6 text-teal-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                </svg>
                <span class="text-lg font-medium">Profile</span>
            </a>
        </div>
    </div>

    <!-- Header -->
    <header class="bg-teal-600 text-white p-4 flex items-center justify-between sticky top-0 z-20 shadow-md">
        <button id="openSidebar" class="text-3xl focus:outline-none">☰</button>

        <div class="flex-1 mx-4">
            <form action="#" method="get" class="relative">
                <input type="text" placeholder="Search the web and earn"
                       class="w-full py-3 px-5 pr-12 rounded-full bg-white text-gray-800 placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-white">
                <button type="submit" class="absolute right-4 top-1/2 -translate-y-1/2 text-teal-600 text-xl">→</button>
            </form>
        </div>

        <a href="setting.php" class="text-3xl focus:outline-none">⚙</a>
    </header>

    <main class="p-4 space-y-6 max-w-md mx-auto">

        <!-- Daily Goal -->
        <div class="bg-white rounded-2xl p-5 shadow-lg">
            <div class="flex justify-between items-center mb-2">
                <div class="text-green-600 font-semibold">Earned <?= number_format($user['balance'], 2) ?> $ balance</div>
                <div class="text-green-600">Goal 1 of 2 – 30 $</div>
            </div>
            <div class="w-full bg-gray-200 rounded-full h-2.5 mb-2 overflow-hidden">
                <div class="bg-green-500 h-2.5 rounded-full" style="width: <?= $daily_goal_progress ?>%"></div>
            </div>
            <div class="text-sm text-gray-600 flex items-center gap-1">
                30 $ Until First Bonus: 3 $ <span class="text-green-500 cursor-help">ℹ</span>
            </div>
            <button class="mt-3 w-full bg-green-50 hover:bg-green-100 text-green-700 font-medium py-3 px-4 rounded-xl flex justify-between items-center transition">
                <span>Claim Your monthly Bonus of <?= $monthly_bonus ?> $</span>
                <span>→</span>
            </button>
        </div>

        <!-- Streak -->
        <div class="bg-white rounded-2xl p-5 shadow-lg">
            <h2 class="font-bold text-lg mb-3">Streak</h2>
            <div class="flex justify-between text-sm mb-1">
                <span>Current Streak: <?= $user['streak_days'] ?> Days</span>
                <span>Next Streak: 7 Days</span>
            </div>
            <div class="w-full bg-gray-200 rounded-full h-2 mb-2 overflow-hidden">
                <div class="bg-green-500 h-2 rounded-full" style="width: <?= min(100, ($user['streak_days'] / 7) * 100) ?>%"></div>
            </div>
            <div class="text-sm text-green-600">
                7 More Days Until Next Bonus <strong><?= $streak_bonus ?> $</strong>
            </div>
        </div>

        <!-- Member Recognition -->
        <div class="bg-white rounded-2xl p-5 shadow-lg">
            <div class="flex justify-between items-center mb-3">
                <h2 class="font-bold text-lg">Member Recognition</h2>
                <button id="toggleCollapse" class="text-teal-600 hover:text-teal-800 font-medium">
                    Collapse <span id="arrow">↑</span>
                </button>
            </div>
            <div id="memberContent">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="font-semibold"><?= htmlspecialchars($user['level']) ?> – <?= $to_next_level ?> $ to Next Level</p>
                        <p class="text-green-600 font-bold mt-1"><?= number_format($user['lifetime_earned'], 2) ?> $ LIFETIME</p>
                    </div>
                    <div class="w-16 h-16 bg-gradient-to-br from-teal-200 to-teal-400 rounded-full flex items-center justify-center text-2xl shadow-inner opacity-80">
                        ◯
                    </div>
                </div>
            </div>
        </div>

        <!-- Updated To Do List / Promo (your requested version) -->
        <div class="space-y-3">
            <p class="text-center font-medium text-white drop-shadow-sm">
                Earn Bonus $ for completing your daily to do list.
            </p>
            <div class="bg-gradient-to-r from-cyan-400 to-teal-500 text-white rounded-2xl p-5 flex items-center justify-between shadow-lg">
                <div class="flex items-center gap-4">
                    <div class="w-14 h-14 bg-white/25 backdrop-blur-sm rounded-full flex items-center justify-center text-3xl shadow-inner">
                        🌈
                    </div>
                    <div>
                        <p class="font-bold text-lg leading-tight">Play & Earn<br>up to 500 $</p>
                    </div>
                </div>
                <a href="play.php" 
                   class="bg-white text-teal-700 px-6 py-3 rounded-xl font-semibold hover:bg-gray-100 active:bg-gray-200 transition shadow-md focus:outline-none focus:ring-2 focus:ring-white/50">
                    Join Now
                </a>
            </div>
        </div>

    </main>

    <!-- Bottom Navigation -->
    <nav class="fixed bottom-0 left-0 right-0 bg-white border-t border-gray-200 flex justify-around py-3 shadow-2xl z-20">
        <a href="dashboard.php" class="flex flex-col items-center text-teal-600">
            <span class="text-2xl">🏠</span>
            <span class="text-xs font-medium">Home</span>
        </a>
        <a href="shop.php" class="flex flex-col items-center text-gray-600 hover:text-teal-700">
            <span class="text-2xl">🛒</span>
            <span class="text-xs">Shop</span>
        </a>
        <a href="answer.php" class="flex flex-col items-center text-gray-600 hover:text-teal-700">
            <span class="text-2xl">❓</span>
            <span class="text-xs">Answer</span>
        </a>
        <a href="logout.php" class="flex flex-col items-center text-gray-600 hover:text-red-600">
            <span class="text-2xl">⋯</span>
            <span class="text-xs">More</span>
        </a>
    </nav>

    <!-- JavaScript for Sidebar + Collapse -->
    <script>
        const sidebar       = document.getElementById('sidebar');
        const overlay       = document.getElementById('sidebarOverlay');
        const openBtn       = document.getElementById('openSidebar');
        const closeBtn      = document.getElementById('closeSidebar');

        function openSidebar() {
            sidebar.classList.remove('-translate-x-full');
            overlay.classList.remove('hidden');
        }

        function closeSidebar() {
            sidebar.classList.add('-translate-x-full');
            overlay.classList.add('hidden');
        }

        openBtn.addEventListener('click', openSidebar);
        closeBtn.addEventListener('click', closeSidebar);
        overlay.addEventListener('click', closeSidebar);

        // Collapse toggle
        const toggleBtn = document.getElementById('toggleCollapse');
        const arrow     = document.getElementById('arrow');
        const content   = document.getElementById('memberContent');

        toggleBtn.addEventListener('click', () => {
            content.classList.toggle('hidden');
            arrow.textContent = content.classList.contains('hidden') ? '↓' : '↑';
        });
    </script>

</body>
</html>